//This file is part of FiveIMSNickCollinsPhD. Copyright (C) 2006  Nicholas M.Collins distributed under the terms of the GNU General Public License full notice in file FiveIMSNickCollinsPhD.help

//N.M.Collins 22 Feb 2006

//one object each for harpsichord and recorder, varying in their event detection mechanisms

OrnamatonInstrument {	
	var s;
	var <database;
	
	//composition
	var ornaments1, wfbachdata, frenchdata; //o1wt;
	var <ornamentplaying; //flag to indicate scheduled ornament underway, don't do other things at the moment 
	var playgroup;
	
	var qbuf,ampbuf;
	
	var chromaticism;
	
	var immediacymode;
	
	var ornamentfunctions, ornamentcounter, ornamentindex;
	
	
	*new {arg debug=0;
		^super.new.initOrnamatonInstrument(debug);
	}
	
	
	initOrnamatonInstrument {arg debug;
	
		s=Server.default;
			
		ornamentplaying= false;
			
		this.initComposing(debug);	
		
		immediacymode=0; //on the beat
		
		ornamentindex=0;
		ornamentcounter=0;
			
	}
	
	analyse {arg condition, inbus, group, analysisgroup, synthdef, trigID, threshold;
		
		playgroup= group;
		
		//JUST LAST 5 seconds to reduce search times in creating ornaments, may re-extend later
		//database=AnalyseEventsDatabase(5, 1, s);
		
		database=AnalyseEventsDatabase(60, 1, s);
		
		
		qbuf= Buffer.read(s, "QspeckernN4096SR44100.wav");
		
		ampbuf = Buffer.alloc(s,11,1); //make an amp template
		
		s.sync(condition);	
		
		//harpsichord specific, might correct for recorder later
		ampbuf.setn(0, [1, 0.24741298212606, 0.30103480714958, 0.11006585136406, 0.099717779868297, 0.087488240827846, 0.047977422389464, 0.028222013170273, 0.015051740357479, 0.020696142991533, 0.042333019755409 ]); 
		
		s.sync(condition);	
		
		database.analyse(inbus, trigID, analysisgroup,threshold, nil, synthdef,[\qbufnum, qbuf.bufnum,\ampbufnum, ampbuf.bufnum]);
		
		
	}
	
	
	//in general ornament character might respect tempo, harmonic structure and emphasis, local key and contour etc
	//ornaments data
	
		
	//trill,tremolo,alternator,quasi-gliss,algorithmic virtuoso
	
	initComposing {arg debug;
		
	
		//general ornament ideas
		ornaments1= [
		
		
		[[0.1,0.1,0.1,0.1],[0,1,0,-1,0], nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},0.5,[0,1,-1]],  //turn1
		
		[[0.2,0.2,0.2,0.2],[0,2,0,-1,0], nil,{0.01.rand2},{0.1.rand2},{rrand(0.75,1.0)},1.0,[0,2,-1]],  //turn2
		
		
		//also one note trill- single note repetition, speeding up \citep[p124-5]{cyr92}
//Caccini trillo 

		[[1,1,0.5,0.5,0.25,0.25,0.125,0.125,0.125,0.125],[0,0,0,0,0,0,0,0,0,0,0], nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0,[0]],  	
	//Caccini gruppo 
	
		[[0.5,0.25,0.25,0.25,0.25,0.25,0.25, 0.125,0.125,0.125,0.125, 0.125,0.125,0.125,0.125, 0.125,0.125,0.125,0.125, 0.125,0.125,0.125,0.125,],[-1,0,-1,0,-1,0,-1, 0,-1,0,-1, 0,-1,0,-1, 0,-1,0,-1, 0,-1,0,-2, 0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0,[0,-1,-2]],
	
			
		];
		
		
		chromaticism=Env.new([0,0,0.1,0,1.0,0.3],[180,60,60,60,60],'sine');
	
		wfbachdata=[
		
		//W.F.Bach's table from his father \citep[p125]{newman95}
		
		[[0.125,0.125,0.125,0.125,0.125],[1,0,1,0,1,0],[1.0,0.7,0.7,0.7,0.7,0.9],{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0,[0,1]],  //trillo
		
		[[0.125,0.125],[0,1,0],[1.0,0.7,0.9],{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0,[0,1]],  //mordant
		
		[[0.125,0.125,0.125,0.125,0.125,0.125,0.125],[1,0,1,0,1,0,-1,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0,[0,1,-1]],  //trillo and mordant
		
		[[0.1,0.1,0.1],[1,0,-1,0], nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},0.5,[0,1,-1]],  //cadence
		
		[[0.125,0.125,0.125,0.125,0.125,0.125,0.125],[-1,0,1,0,1,0,1,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0,[0,1,-1]],  //doppelt-cadence
		
		[[0.125,0.125,0.125,0.125,0.125,0.125,0.125],[1,0,-1,0,1,0,1,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0,[0,1,-1]],  //idem
		
		[[0.125,0.125,0.125,0.125,0.125,0.125,0.125],[-1,0,1,0,1,0,-1,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0,[0,1,-1]],  //doppelt-cadence and mordant
		
		[[0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125],[1,0,-1,0,1,0,1,0,1,0,-1,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0,[0,1,-1]],  //idem and mordant
		[[0.5],[-1,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0,[0,-1]],  //accent steigend
		
		[[0.5],[1,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0,[0,1]],  //accent fallend
		
		[[0.5,0.125,0.125],[-1,0,-1,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0,[0,-1]],  //accent and mordant
		
		[[0.5,0.125,0.125,0.125,0.125],[1,0,1,0,1,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0,[0,1]],  //accent and trillo
		
		];
		
		//Francois Couperin table from \emph{Pi\`{e}ces de clavecin, Book 1, Paris, 1713} \citep[p134-5]{cyr92} 
		//not all suitable for adaptation
		
		//also added a few from D'Anglebert \citep[p133]{cyr92}

		frenchdata=[
		
		[[0.125,0.125],[0,-1,0],[0.9,0.7,1.0],{0.01.rand2},{0.05.rand2},{rrand(0.75,1.0)},1.0,[0,-1]],  //pince simple

		[[0.083,0.083,0.083,0.083,0.083,0.083],[0,-1,0,-1,0,-1,0],nil,{0.01.rand2},{0.05.rand2},{rrand(0.75,1.0)},1.0,[0,-1]],  //pince double
		[[0.25,0.125,0.125],[-1,0,-1,0],nil,{0.01.rand2},{0.05.rand2},{rrand(0.75,1.0)},1.0,[0,-1]],  //port devoix simple
		
		[[0.5],[-1,0],nil,{0.01.rand2},{0.05.rand2},{rrand(0.75,1.0)},1.0,[0,-1]],  //port de voix coulee (apoggiatura)
		
		[[0.5,0.125,0.125,0.125,0.125],[-1,0,-1,0,-1,0],nil,{0.01.rand2},{0.05.rand2},{rrand(0.75,1.0)},1.0,[0,-1]],  //port de voix double
		
		[[0.6,0.1,0.1,0.1,0.1],[1,0,1,0,1,0],nil,{0.01.rand2},{0.05.rand2},{rrand(0.75,1.0)},1.0,[0,1]],  //treblement lie sans etre appuye (not entire cadential formula)
		
		[[0.5,0.1,0.1,0.1,0.1,0.1],[1,1,0,1,0,1,0],nil,{0.01.rand2},{0.05.rand2},{rrand(0.75,1.0)},1.0,[0,1]],  //tremblement detache		
		[[1.0,0.25,0.25,0.25,0.25],[-2,0,-1,-2,-1,0],nil,{0.01.rand2},{0.05.rand2},{rrand(0.75,1.0)},1.0,[0,-1,-2]],  //turn (double)		
		//now D'Anglebert
		[[0.125,0.125,0.125,0.125],[2,1,0,-1,0],nil,{0.01.rand2},{0.05.rand2},{rrand(0.75,1.0)},1.0,[0,1,2,-1]],  //sur un tierce	
		[[0.5,0.5,0.125,0.125],[-1,-1,0,-1,0],nil,{0.01.rand2},{0.05.rand2},{rrand(0.75,1.0)},1.0,[0,-1]],  //cheute et pince	
		[[0.125,0.125,0.25,0.25,0.25, 0.125,0.125,0.125,0.125, 0.125,0.125,0.125,0.125, 0.125,0.125,0.125,0.125],[1,0,-1,0,1,0,-1,-2,-1, 0,-1,0,-1,0,-1,0,-1,0],nil,{0.01.rand2},{0.05.rand2},{rrand(0.75,1.0)},1.0,[0,1,-1,-2]],  //autre (trill)
		
		];
		
		
			//if any array nil, replace amps with 1s
		//[0=[beat iois],1=[pitch degrees],2=[amps] other params- 3= +ioi noise, 4= +pitch noise, 5= *amp noise, 6= *dutycycle, 7=[scale degrees appearing]]
		
		
		//function name (use perform to access), initial time available (generate availability envelopes from this), function for number in a row allowed, and resolvable or not, overall weight multiplier
		ornamentfunctions= [[\wfbach,60,{rrand(1,rrand(1,5))},true, 1], [\french,0,{rrand(1,rrand(1,5))},true, 1],[\trill,120, {rrand(1,4)},true, 1],[\gliss, 180, {[1,2,3].wchoose([0.9,0.07,0.03])},true, 0.8],  [\ornament1,240,{rrand(1,2)},true, 0.5],[\databasegesture1,300,{1},false, 0.4]];
		
		//
		if (debug>3.5) {ornamentfunctions= [[\wfbach,0,{rrand(1,rrand(1,5))},true, 1], [\french,0,{rrand(1,rrand(1,5))},true, 1],[\trill,0, {rrand(1,4)},true, 1],[\gliss, 0, {[1,2,3].wchoose([0.9,0.07,0.03])},true, 0.8],  [\ornament1,0,{rrand(1,2)},true, 0.5],[\databasegesture1,0,{1},false, 0.4]];};
		
		
		//create random availability envelopes, choose some non-intersecting peaks between entry time and 480, always wild after 6 minutes
		
		ornamentfunctions.size.do({arg i; 
		var times, levels, span, numpeaks;
		var wt;
		
		wt= ornamentfunctions[i][4];
		
		//8 minutes= 480
		span= 480-ornamentfunctions[i][1];
		
		numpeaks=span.div(15);
		
		times= Array.fill(numpeaks,{arg j; (span*(j/(numpeaks)))+(10.rand)});
		
		levels=Array.fill(times.size,{arg j; [1,rrand(0.0,1.0),rrand(0.0,1.0),exprand(0.1,0.9),0,0].wrapAt(j)   });
		
		ornamentfunctions[i][1]= Env([0,0]++(levels*wt),[ornamentfunctions[i][1]]++times,'linear');  }); 
		
	}



//contour echo, playback from database in order at some delay, shuffled or inverted degrees etc
	
	//knowing time in piece choose ornament type	
	//different modes- cascade of trills, traditional, simple, computer delivered
	chooseOrnament {arg period, key, progress;
		var orn, tmp;
		//can create ornaments algorithmically
		
		//if readin from counter, continue
		
		if(ornamentcounter>0.5,{
		
			ornamentcounter=ornamentcounter-1;
		
		},{
			
			//else find next ornament mode
			
			//make array
			tmp=ornamentfunctions.collect({arg val; val[1].at(progress); });
			
			//ie all too near zero, make even choice amongst those available
			if((tmp.sum)<0.01,{tmp= ornamentfunctions.collect({arg val; if(val[1].times[0]>=(progress-0.1),1,0); });});		
			tmp=tmp.normalizeSum;
			
			ornamentindex=(0..(tmp.size)).wchoose(tmp);
			
			ornamentcounter= ornamentfunctions[ornamentindex][2].value;
			
			ornamentcounter=ornamentcounter-1;
			
		});
		
		
		[ornamentfunctions[ornamentindex][0],ornamentindex,ornamentcounter,tmp].postln;
		
		orn=this.perform(ornamentfunctions[ornamentindex][0],period, key, progress);
		
		if(ornamentfunctions[ornamentindex][3],{orn=this.resolveOrnament(orn, key, progress);});
		
		//orn=this.trill; //sound good!
		//orn=wfbach.choose;
		//orn=this.gliss; //fine
		//could generate some gestures directly from database here rather than 'resolving'
		//orn=this.resolveOrnament(orn, key, progress);
		
		^orn;
		
	}

	


//[1,1,0.5,1,0.25,0.25,0.25,0.25,1,1,1,0.5].normalizeSum

	wfbach {
		^wfbachdata.wchoose([ 0.125, 0.125, 0.0625, 0.125, 0.03125, 0.03125, 0.03125, 0.03125, 0.125, 0.125, 0.125, 0.0625 ]);
	}
	
	
	
//[1,1,1,1,0.5,0.5,0.5,0.5,1,0.5,0.25].normalizeSum
	french {
		^frenchdata.wchoose([ 0.12903225806452, 0.12903225806452, 0.12903225806452, 0.12903225806452, 0.064516129032258, 0.064516129032258, 0.064516129032258, 0.064516129032258, 0.12903225806452, 0.064516129032258, 0.032258064516129 ]);
	}

	ornament1 {
		^ornaments1.choose;
	}
	
	
	//canon at some delay, 3-10 notes in past up to current present, using captured rhythm
	//could also do inversion
	databasegesture1 {arg period, key, progress; 
		var num, orn, tmp,tmp2;
		
		num= rrand(min(database.list.size,3),min(database.list.size,10));
		
		//safety
		if((num>(database.list.size)) || (num<2),{
		
		^this.resolveOrnament(this.ornament1, key, progress);
		
		},{

		tmp=Array.fill(num,{arg i;  [i,0]});
		
		tmp2= Array.fill(num-1,{arg i;  (database.list[i][0])- (database.list[i+1][0])})/period; //compensate for later multiplication since these are 
		//absolute times,not beat times
		
		tmp.postln;
		tmp2.postln;
		
		orn= [tmp2,tmp, nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0,[0]]; //last doesn't actually matter since no resolve call
		
		//reverse (restores performance order, o/w will actually be backwards)
		if(0.7.coin,{orn[0]=orn[0].reverse; orn[1]=orn[1].reverse;});
		
		}) ;
	
		orn.postln;
		^orn;
	
	}



	////also make alternating pattern
//	makeTremolo {
//	
//	}



//can generalise this by also selecting start note, but probably want as a different mode

	trill {
		var start, num, time;
		var orn;
		var weights;
		var dutycycle;
		
		start=#[0,1].choose; //from above or from start note?
			
		weights=#[ 0.095527212370053, 0.10614134707784, 0.11793483008649, 0.1310387000961, 0.14559855566233, 0.14559855566233, 0.10191898896363, 0.071343292274541, 0.049940304592178, 0.034958213214525 ]; //((Array.geom(5,1,0.9).reverse)++(Array.geom(5,1,0.7))).normalizeSum;
			
		num=	[6,7,8,9,10, 11,13,17,19,23].wchoose(weights);
		
		time= [0.5,1.0].wchoose([0.2,0.8]);		
		
		time=time/num;	
			
		dutycycle=[1.0,rrand(0.5,1.0),exprand(0.1,1.0),rrand(0.1,0.4)].wchoose([0.5,0.2,0.2,0.1]);
			
		orn= [Array.fill(num-1,{time}),Array.fill(num,{arg i; if(i.even,start,1-start);}),nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},dutycycle,[0,1]];  
		
		//add tail turn figure?	
		if( (((start==0) && (num.odd)) || ((start==1) && (num.even))) && (0.5.coin), {
		
		//penultimate is turn rather than above
		orn[1][num-2]=(-1);
		
		orn[7]=[0,1,-1];
		});
		
		//make last two iois longer? 
		
		
		//trill slowing down throughout? 
	
		^orn
	}
	
	
	gliss {
		var direction, num, centre, degrees;
		var time;
		var dutycycle;
		var iois, amps;
		
		num= [rrand(5,10),rrand(5,15),rrand(10,20)].choose;
		
		direction= [1,-1].choose;
		
		centre= [0,num.rand,num-1].wchoose([0.2,0.7,0.1]);
		
		time= [0.5,1.0,1.5].wchoose([0.2,0.7,0.1]);			
		//centre.postln;	
			
		degrees=Array.fill(num,{arg i;  (i-centre)*direction; });	
		dutycycle=[1.0,rrand(0.5,1.0),exprand(0.1,1.0),rrand(0.1,0.3)].wchoose([0.4,0.3,0.2,0.1]);
		
		iois= [Array.fill(num-1,{time/num}),(Array.series(num-1,1,rrand(0.1,2)).normalizeSum)*time,(Array.series(num-1,1,rrand(0.1,2)).reverse.normalizeSum)*time, (Array.geom(num-1,1,rrand(0.8,0.99)).normalizeSum)*time,(Array.geom(num-1,1,rrand(0.8,0.99)).reverse.normalizeSum)*time].choose;
		
		amps=[Array.fill(num,1),Array.geom(num,1,rrand(0.8,0.99)),Array.geom(num,1,rrand(0.8,0.99)).reverse].wchoose([0.5,0.25,0.25]);
					
		^[iois,degrees,amps,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},dutycycle,degrees.rotate(centre.neg)]; 
	}
	



	resolveOrnament {arg ornament, key, progress;
		var pitches, diatonic, scale, chromaticchance;
		var notechance, basenoteindex, basenote, ornamentnotes, findnotes;
		var temp,temp2,temp3;
		var diatonicscale;
		var ornament2;
		
		diatonicscale=#[0,2,4,5,7,9,11];
		
		//is always major healthy? Always Aeolian probably more fun, though mathematically equivalent
		scale=(diatonicscale+key)%12;
		
		//find pitches involved with respect to key centre
		//can search whole database, prioritising closer to start
		
		//could restrict to over last x seconds via database.findEventList(now-2,now), now= Main.elapsedTime
		
		pitches= database.list.collect({arg val; (((val[7].cpsmidi)+1.012706247691995).round(1.0).asInteger)});
				
		diatonic= List.new;		
				
		//pitches in order from most recent backwards in time
		pitches.do({arg val,j; 
		var inscale, testval;
		
		testval=val%12;
		
		inscale=false;
		
		scale.do({arg test; if(test==testval){inscale=true;}; });
		
		if(inscale,{diatonic.add(j)});
		
		});
		
		chromaticchance=chromaticism.at(progress);
		
		if (diatonic.isEmpty,{"no key pitches!".postln; chromaticchance=1.0;});
		
		//or change key to match first in list and work diatonically
		
		//diatonic or chromatic	 ornament? 
		if(chromaticchance.coin,{
			
			"chromatic".postln;
			
			notechance= Array.geom(10.min(pitches.size),1,0.9).normalizeSum; //can vary geom mult over time
			
			basenoteindex=(0..(notechance.size-1)).wchoose(notechance);
			
			basenote= pitches[basenoteindex];
			
			findnotes= basenote+(ornament[7]);
			
		},{
			
			"diatonic".postln;
			
			notechance= Array.geom(10.min(diatonic.size),1,0.9).normalizeSum; //can vary geom mult over time
			
			//notechance.postln;
			
			basenoteindex=diatonic.wchoose(notechance); //diatonic.at((0..(notechance-1)).wchoose(notechance));
			
			basenote=pitches[basenoteindex];
			
			//which diatonic note, so can work out relative 
			
			//normalise into C to ease calculation of octave
			temp= (basenote-key)%12;
			
			//which diatonic tone index? 
			temp2= 0;
			
			diatonicscale.do({arg val,j; if(val==temp,{temp2=j;})});
			
			
			//[\index,basenoteindex,\basenote,basenote,\key, key,\normalised, temp,\diatonicindex, temp2].postln;
			
			findnotes= ornament[7].collect({arg val; 
			var refindex, scalenote; 
			
			refindex= val+temp2;
			
			scalenote= diatonicscale.wrapAt(refindex);
			
			//octave
			temp3= refindex.div(7); //7 indices in diatonic scale
			
			basenote+(12*temp3)+scalenote-temp; //key is restored via basenote
			}); 
		
		});
		
		//findnotes.postln;
		
		ornamentnotes=Array.fill(findnotes.size,{List.new;});
		
		//if any missing will use repitch of base note
		
		//prepare lists
		findnotes.do({arg val,i;  pitches.do({arg val2,j; if(val2==val, {ornamentnotes[i].add(j); }); }); });
	
		//check isEmpty when prepare performance instruction version
		//ornamentnotes.do({arg val,i; if(val.isEmpty,{ornamentnotes[i]= nil;})})
	
		//ornamentnotes.postln;
		
		ornament2=ornament.copy;
		
		//prepare ornament for rendering via events
		
		//ornament[1] to index list
		temp= ornament[1].collect({arg val; var index=0; ornament[7].do({arg val2,j; if(val==val2,{index=j;}); }); index}); 
		
		//temp.postln;
		
		//prepare actual event source, choose a random one from the event list 
		temp2= temp.collect({arg which, j; var val; val= ornamentnotes[which]; if(val.isEmpty || (j==0),{[basenoteindex,ornament[7][which]]},{[val.choose,0]}); });
		
		//temp2.postln;
		
		//resolved version with event indices and playback ratios
		ornament2[1]= temp2;
	
		^ornament2;
	}

//don't want to repitch too far, so don't find 



	//using nextbeat/period schedule ornamental flourishes
	//key 0-11, progress time since piece began 
	compose {arg nextbeat, period, key, progress;
		var ornamentsource, ornament,ioisource,iois, rates, amps, data;
		var ioinoise, pitchnoise, ampnoise, dutycycle;
		var delay;
		var target;
		
		if(database.list.notEmpty,{
		
		ornamentplaying= true;
		
		//what is chosen should vary over time
		//Envelopes for different ornaments? read off all values and make a probability template from them?
		//note how long each ornament will be, control generation accordingly
		
		//could actually directly generate from the database a resolved ornament, so have this as another option
		//ornamentsource= this.chooseOrnament(progress);
//		
//		ornament=this.resolveOrnament(ornamentsource, key, progress);
//		

		ornament= this.chooseOrnament(period, key, progress);
		
		ioinoise=(ornament[3]) ? 0.0;
		pitchnoise=(ornament[4]) ? 0.0;
		ampnoise=(ornament[5]) ? 1.0;
		dutycycle=(ornament[6]) ? 1.0;
	
		ioisource= (ornament[0]).value;	
		
		iois= Pseq((ioisource)*period,1).asStream; //adjusted to current period
		
		rates= Pseq((ornament[1]).value,1).asStream;
		
		amps= (ornament[2]).value;
		
		if(amps.isNil,{amps= Array.fill(ioisource.size+1,1)});
		
		amps= Pseq(amps,1).asStream;
		
		
		//will choose based on other criteria
		
		//data= database.list.first; //most recent will be manipulated
		
		//[ornament, ioisource, iois].postln;
		
	
		//(ioisource)*period aim for this time as on beat or onbeat at start of ornament? 
		
		target=ioisource.sum;
		
		delay= 1.0-(target%1.0); //need to know how many stray beats  
		
		
		//immediacy envelope, choices where to beat match, also depends how soon next beat is
		
		if(immediacymode==0,{
		//on beat
		
		//calculated so end note will be onbeat
		delay= nextbeat+(delay*period);
		
		//delay= [nextbeat-(period*0.5),nextbeat,nextbeat+(period*0.5), nextbeat+period].wchoose([0.05,0.8,0.05,0.1]);
		
		if((delay-(s.latency))<(Main.elapsedTime),{delay= nextbeat; if((delay-(s.latency))<(Main.elapsedTime),{delay=nextbeat+period;}); });
		
		//Array.fill(100,{rrand(1,rrand(1,rrand(1,10)))}).sort.plot
		//1 in 50 swap, quite rare but can happen, biast to not happen too many times
		if(0.02.coin,{immediacymode=rrand(1,rrand(1,10));});
		
		},{
		//immediate no delay
		
		delay=Main.elapsedTime+(s.latency);
		
		immediacymode=immediacymode-1;
		
		});
		
	
		//latency compensation
		SystemClock.schedAbs(delay-(s.latency),{var nextioi;
			var nextevent, nextrate,ratecompensation;
			
			nextioi=(iois.next.value);
			
			if(nextioi.notNil, {nextioi=nextioi+(ioinoise.value)});	
			nextevent=rates.next.value;
			
			//"new event".postln;
			//nextevent.postln;
			
			data= database.list[nextevent[0]];
			
			nextrate=1.0594630943593**((nextevent[1].value)+(pitchnoise.value));
			
			//length compensation for note
			ratecompensation= nextrate.reciprocal;
			
			
			if(data.notNil,{
		
			s.sendBundle(s.latency,[\s_new,\OrnamatonPlayBuf,-1,0,playgroup.nodeID,\outbus,0, \bufnum, database.soundbuf.bufnum, \startPos, data[1], \length, (data[2])*ratecompensation*(dutycycle.value), \amp, (amps.next.value)*(ampnoise.value), \rate, nextrate]);
		
			//Synth.head(playgroup, \OrnamatonPlayBuf,[\outbus,0, \bufnum, database.soundbuf.bufnum, \startPos, data[1], \length, (data[2])*ratecompensation*(dutycycle.value), \amp, (amps.next.value)*(ampnoise.value), \rate, nextrate]);
//			   
			});  
			  
			//nextioi.postln;  
			  
			if(nextioi.isNil,{ornamentplaying=false;});  
			
			//["scheduling ornament",nextioi, ornamentplaying].postln;
			  
			nextioi
		});
		
		//ornamentplaying=false; //must cover this condition else ornamentation stops! 
		
		
		});
				
	}
	
		
	*initClass {
	
		StartUp.add({
	
		//mono sample, panned
		SynthDef.writeOnce(\OrnamatonPlayBuf,{arg outbus=0, bufnum=0, startPos=0, length=0.1, amp=1.0, rate=1.0, pan=0.0;  
			var playbuf, env;
			
				env=EnvGen.ar(Env([0,1,1,0],[0.001,length-0.002,0.001]),doneAction:2);
				
				playbuf=PlayBuf.ar(1, bufnum, rate, 1, startPos, 0)*amp;
			
				Out.ar(outbus, Pan2.ar(playbuf*env,pan));
			});
		
		2.do({arg i;
		
				SynthDef.writeOnce(\analyseharpsichorddatabase++((i+1).asSymbol),{arg inbus=8, soundbufnum=0, analysisbufnum=1, trigID=101, threshold=0.34, qbufnum, ampbufnum, debugbufnum;  
				var recbuf, input, analysisinput;
				var freq, hasFreq;
				
				input=In.ar(inbus, i+1);
				
				recbuf= RecordBuf.ar(input,soundbufnum,0,1.0,0.0,1,1,1);
				
				analysisinput= if(i==0, {input},{Mix(input)});
				
				# freq, hasFreq = Qitch.kr(analysisinput, qbufnum,0.01,1,ampbufnum, maxfreq:1500);
	
				//could have medlen param
				freq= Median.kr(11,freq);
				
				AnalyseHarpsichord.ar(analysisinput, analysisbufnum, threshold, trigID, 1, freq) ; //(, debugbufnum); 
				
				//AnalyseRecorder.ar(analysisinput, analysisbufnum, threshold, trigID, 1, freq) ; //(, debugbufnum); 
				
				
				});
				
				
				
				SynthDef.writeOnce(\analyserecorderdatabase++((i+1).asSymbol),{arg inbus=8, soundbufnum=0, analysisbufnum=1, trigID=101, threshold=0.34, qbufnum, ampbufnum, debugbufnum;  
				var recbuf, input, analysisinput;
				var freq, hasFreq;
				
				input=In.ar(inbus, i+1);
				
				recbuf= RecordBuf.ar(input,soundbufnum,0,1.0,0.0,1,1,1);
				
				analysisinput= if(i==0, {input},{Mix(input)});
				
				# freq, hasFreq = Qitch.kr(analysisinput, qbufnum,0.01,1,ampbufnum, maxfreq:1500);
	
				//could have medlen param
				freq= Median.kr(11,freq);
				
				//AnalyseHarpsichord.ar(analysisinput, analysisbufnum, threshold, trigID, 1, freq) ; //(, debugbufnum); 
				
				AnalyseRecorder.ar(analysisinput, analysisbufnum, threshold, trigID, 1, freq) ; //(, debugbufnum); 
				
				
				});


		});
	
		});
	
	//old version, made into diatonic steps above
//		//W.F.Bach's table from his father \citep[p125]{newman95}
//		
//		[[0.125,0.125,0.125,0.125,0.125],[2,0,2,0,2,0],[1.0,0.7,0.7,0.7,0.7,0.9],{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0],  //trillo
//		
//		[[0.125,0.125],[0,2,0],[1.0,0.7,0.9],{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0],  //mordant
//		
//		[[0.125,0.125,0.125,0.125,0.125,0.125,0.125],[2,0,2,0,2,0,-1,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0],  //trillo and mordant
//		
//		[[0.1,0.1,0.1],[2,0,-1,0], nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},0.5],  //cadence
//		
//		[[0.125,0.125,0.125,0.125,0.125,0.125,0.125],[-1,0,2,0,2,0,2,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0],  //doppelt-cadence
//		
//		[[0.125,0.125,0.125,0.125,0.125,0.125,0.125],[2,0,-1,0,2,0,2,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0],  //idem
//		
//		[[0.125,0.125,0.125,0.125,0.125,0.125,0.125],[-1,0,2,0,2,0,-1,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0],  //doppelt-cadence and mordant
//		
//		[[0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125],[2,0,-1,0,2,0,2,0,2,0,-1,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0],  //idem and mordant
//		[[0.5],[-1,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0],  //accent steigend
//		
//		[[0.5],[2,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0],  //accent fallend
//		
//		[[0.5,0.125,0.125],[-1,0,-1,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0],  //accent and mordant
//		
//		[[0.5,0.125,0.125,0.125,0.125],[2,0,2,0,2,0],nil,{0.01.rand2},{0.1.rand2},{rrand(0.5,1.0)},1.0],  //accent and trillo
//		
//		

	
	
	}
	
	
}